package eventbus

import (
	"code.justin.tv/cb/achievements/internal/awscredentials"
	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/subscriber/sqsclient"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/endpoints"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/pkg/errors"
)

type Eventbus struct {
	eventbusClient *sqsclient.SQSClient
}

func NewEventbusClient(env string, region string, queueURL string, mux *eventbus.Mux) (*Eventbus, error) {
	sess, err := session.NewSession(&aws.Config{
		Credentials:         awscredentials.New(env, region),
		STSRegionalEndpoint: endpoints.RegionalSTSEndpoint,
		Region:              aws.String(region),
	})
	if err != nil {
		return nil, errors.Wrap(err, "eventbus: failed to instantiate new session")
	}

	client, err := sqsclient.New(sqsclient.Config{
		Session:    sess,
		Dispatcher: mux.Dispatcher(),
		QueueURL:   queueURL,
	})
	if err != nil {
		return nil, errors.Wrap(err, "eventbus: failed to instantiate eventbus sqs client")
	}

	return &Eventbus{
		eventbusClient: client,
	}, nil
}

func (e *Eventbus) Shutdown() error {
	return e.eventbusClient.Shutdown()
}
