package redshift

import "context"

//Redshift is the interface for interacting with achievement redshift tables
type Redshift interface {
	BroadcastNHours30Days(ctx context.Context, minutesThreshold int) ([]*MinutesBroadcastAggregate, error)
	NBroadcastDays30Days(ctx context.Context, daysThreshold int) ([]*UniqueDaysBroadcastAggregate, error)
	NConcurrents30Days(ctx context.Context, avgCCUThreshold float64) ([]*ConcurrentViewersBroadcastAverage, error)
	NHoursLifetime(ctx context.Context) ([]*LifeTimeBroadcastDurationAggregate, error)
	NFollowers(ctx context.Context, followerThreshold int) ([]*NFollowersAggregate, error)
	NMinuteWatchedLifetime(ctx context.Context) ([]*LifeTimeViewingDurationAggregate, error)
	NDaysNoViewers(ctx context.Context) ([]*ConsecutiveSessionsNoViewersAggregate, error)
	NUniqueChatterBroadcast(ctx context.Context) ([]*UniqueChatterBroadcastAggregate, error)
	NRaidConsecutiveBroadcast(ctx context.Context) ([]*RaidsOverThreshold, error)
	NViewers(ctx context.Context) ([]*MaxConcurrentViewers, error)

	QuestMetrics(ctx context.Context) ([]*QuestMetricAggregate, error)

	DeleteAndVacuumRows(ctx context.Context, tableName string) error
}
