package redshift

// MinutesBroadcastAggregate is the struct for aggregating minute broadcast
// over a time interval
type MinutesBroadcastAggregate struct {
	ChannelID string
	Minutes   int
}

// UniqueDaysBroadcastAggregate is the struct for aggregating unique dow
// a channel has broadcast over an interval
type UniqueDaysBroadcastAggregate struct {
	ChannelID  string
	UniqueDays int
}

// ConcurrentViewersBroadcastAverage is the struct for average CCUs over 30 days
// for the channel
type ConcurrentViewersBroadcastAverage struct {
	ChannelID  string
	AverageCCU float64
}

// LifeTimeBroadcastDurationAggregate is the struct for aggregating the number
// of min a channel has broadcast over an interval
type LifeTimeBroadcastDurationAggregate struct {
	ChannelID        string
	MinutesBroadcast int
}

// LifeTimeViewingDurationAggregate is the struct for aggregating the number of
// min a channel has been watched over an interval
type LifeTimeViewingDurationAggregate struct {
	ChannelID      string
	MinutesWatched int
}

// ConsecutiveSessionsNoViewersAggregate is the struct for aggregating the number
// of consecutive sessions that a channel had less than 3 avg concurrent viewers
type ConsecutiveSessionsNoViewersAggregate struct {
	ChannelID           string
	ConsecutiveSessions int
}

// NFollowersAggregate is the struct for aggregating the number of
// min a channel has been watched over an interval
type NFollowersAggregate struct {
	ChannelID string
	Followers int
}

// MaxConcurrentViewers holds the maximum amount of concurrent viewers
// for a channel over an interval
type MaxConcurrentViewers struct {
	ChannelID  string
	MaxViewers int
}

// UniqueChatterBroadcastAggregate is the struct for aggregating the number of
// unique chatters that have sent a message in the last 10 min for a particular
// channel
type UniqueChatterBroadcastAggregate struct {
	ChannelID    string
	UniqueLogins int
}

// RaidsOverThreshold is the struct that contains the number of
// raiding parties hosted by the user that exceeds 2 raiders
type RaidsOverThreshold struct {
	ChannelID string
	RaidCount int
}

// QuestMetricAggregate is the type that holds the data used to determine
// the progress towards quest completion.
// We can use the same struct for each quest because the stats to measure progress
// are the same for each, just with different requirements.
type QuestMetricAggregate struct {
	ChannelID                    string
	FollowCount                  int
	MinuteBroadcastCount         int
	UniqueDays                   int
	AverageCCU                   float64
	LiveOnlyAverageCCU           float64
	RaidedMinuteWatched          int
	HostedMinuteWatched          int
	TotalMinuteWatched           int
	UniqueChatters               int
	FilteredMinuteBroadcastCount int
	FilteredUniqueDays           int
}

// MinuteWatchedAggregate holds the different classifications of minute watched for a channel.
type MinuteWatchedAggregate struct {
	ChannelID           string
	RaidedMinuteWatched int
	HostedMinuteWatched int
	TotalMinuteWatched  int
}
