package ripley

import (
	"context"
	"fmt"

	"code.justin.tv/foundation/twitchclient"
	riptwirp "code.justin.tv/revenue/ripley/rpc"
)

type Client struct {
	client riptwirp.Ripley
}

func NewClient(host string) *Client {
	client := riptwirp.NewRipleyProtobufClient(host, twitchclient.NewHTTPClient(twitchclient.ClientConf{
		Host: host,
	}))
	return &Client{
		client: client,
	}
}

func (c *Client) GetUserPayoutStatus(ctx context.Context, channelID string) (*UserPayoutStatus, error) {
	resp, err := c.client.GetPayoutType(ctx, &riptwirp.GetPayoutTypeRequest{
		ChannelId: channelID,
	})
	if err != nil {
		return nil, fmt.Errorf("get user payout status: %w", err)
	}

	return &UserPayoutStatus{
		ChannelID:   channelID,
		IsAffiliate: resp.GetPayoutType().GetIsAffiliate(),
		IsDeveloper: resp.GetPayoutType().GetIsDeveloper(),
		IsPartner:   resp.GetPayoutType().GetIsPartner(),
	}, nil
}
