package ripley

import (
	"context"
)

// Ripley is a generic ripley service interface, to be implemented
// by a specific package (or mock).
type Ripley interface {
	// GetUserPayoutStatus calls moneypenny to determine a channels payout entity status
	GetUserPayoutStatus(ctx context.Context, id string) (*UserPayoutStatus, error)
}

// UserPayoutStatus is a representation of a channelid's payout status
type UserPayoutStatus struct {
	ChannelID   string `json:"channel_id"`
	IsAffiliate bool   `json:"is_affiliate"`
	IsDeveloper bool   `json:"is_developer"`
	IsPartner   bool   `json:"is_partner"`
}
