package sns

import (
	"context"
	"time"
)

// SNS is the client for sending SNS messages to the contract engine
type SNS interface {
	PublishNotification(ctx context.Context, message interface{}) error
}

// NotificationMessage is the format of the SNS message we will send to WebSub and Notifier
type NotificationMessage struct {
	Key         string    `json:"key"`
	ChannelID   string    `json:"channel_id"`
	CompletedAt time.Time `json:"completed_at"`
}
