package tracking

import (
	"code.justin.tv/cb/achievements/internal/clients/db"
)

const (
	// AchievementCompleted is the name of the event that science tracks with
	AchievementCompleted = "achievement_completed"

	// SpadeParallelWorkersCount is the number of workers spawned
	SpadeParallelWorkersCount = 300

	// SpadeEventBufferSize is the max number of spade events we send in each batch
	SpadeEventBufferSize = 32
)

// Tracking sends event data to Spade
type Tracking interface {
	Close()
	TrackCompletedAchievements(progressions []db.Progression)
}

// SpadeEvent is a struct shared by both achievements and quests. Only use the
// appropriate fields
type SpadeEvent struct {
	Name            string  `json:"-"`
	ServerTimestamp float64 `json:"server_timestamp"`
	ChannelID       string  `json:"channel_id"`
	AchievementID   string  `json:"achievement_id"`
	AchievementName string  `json:"achievement_name"`
	Level           int     `json:"level"`
	QuestID         string  `json:"quest_id"`
	QuestName       string  `json:"quest_name"`
}
