package users

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/web/users-service/client/usersclient_internal"
	"code.justin.tv/web/users-service/models"
)

// UserServiceClient clients struct
type UserServiceClient struct {
	host   string
	client usersclient_internal.InternalClient
}

// NewUserServiceClient creating new UserServices client
func NewUserServiceClient(host string) (*UserServiceClient, error) {
	usersServiceClient, err := usersclient_internal.NewClient(twitchclient.ClientConf{
		Host: host,
	})

	if err != nil {
		return nil, err
	}

	return &UserServiceClient{
		host:   host,
		client: usersServiceClient,
	}, nil
}

// GetNonBannedUsers calls users service for a batch of ids and filters out dmca banned users
func (u *UserServiceClient) GetNonBannedUsers(ctx context.Context, ids []string) (*models.PropertiesResult, error) {
	params := &models.FilterParams{
		IDs:             ids,
		NotDeleted:      true,
		NoTOSViolation:  true,
		NoDMCAViolation: true,
	}

	return u.client.GetUsers(ctx, params, nil)
}

func (u *UserServiceClient) IsAdmin(ctx context.Context, userID string) (bool, error) {
	user, err := u.client.GetUserByID(ctx, userID, nil)
	if err != nil {
		return false, err
	}

	if user == nil {
		return false, nil
	}

	if user.Admin == nil {
		return false, nil
	}

	return *user.Admin, nil
}
