package users

import (
	"context"

	"code.justin.tv/web/users-service/models"
)

// Users is a generic users service interface, to be implemented
// by a specific package (or mock).
type Users interface {
	// GetNonBannedUsers calls users service for a batch of ids and filters out dmca banned users
	GetNonBannedUsers(ctx context.Context, ids []string) (*models.PropertiesResult, error)
	// IsAdmin calls users service and returns whether or not the userID is an admin
	IsAdmin(ctx context.Context, userID string) (bool, error)
}
