package notifications

import (
	"context"
)

type Notifier interface {
	// PublishAchievementComplete displays an onsite notification when an
	// achievement is complete
	PublishAchievementComplete(ctx context.Context, key string, channelID string, progress int) error

	// PublishQuestComplete displays an onsite notification when a quest is
	// complete
	PublishQuestComplete(ctx context.Context, key string, channelID string) error
}

// AchievementsBadgeURLMap is a map from achievement key to badge url, so we can display the badge for onsite notifications
var AchievementsBadgeURLMap = map[string]string{
	"single_dashboard_visit":        "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_know-your-stuff_sm-2x.png",
	"single_broadcast_title":        "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_name-of-the-game_sm-2x.png",
	"n_autohost":                    "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_mr-roboto_sm-2x.png",
	"broadcast_n_hours_30_days":     "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_part-time_sm-2x.png",
	"n_broadcast_days_30_days":      "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_like-clockwork_sm-2x.png",
	"n_concurrents_30_days":         "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_who-watches-the-watchers_sm-2x.png",
	"n_hours_lifetime":              "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_the-empire-business_sm-2x.png",
	"first_stream":                  "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_it-s-happening_sm-2x.png",
	"single_select_game_community":  "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_we-belong_sm-2x.png",
	"n_minute_watched_lifetime":     "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_kind-of-a-big-deal_sm-2x.png",
	"n_days_no_viewers":             "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_hang-in-there_sm-2x.png",
	"n_followers":                   "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_what-is-thy-bidding_sm-2x.png",
	"n_viewers_lifetime":            "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_people-know-me_sm-2x.png",
	"talk_a_little":                 "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_talk-a-little_sm-2x.png",
	"n_unique_chatter_broadcast":    "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_talk-to-me_sm-2x-v2.png",
	"single_twitchcon2017":          "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_twitchcon-get_sm-2x.png",
	"single_chat":                   "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_message-in-a-bottle_sm-2x.png",
	"n_raid_consecutive_broadcast":  "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_raiding-party_sm-2x.png",
	"n_same_week_stream_start_time": "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_same-time-next-week_sm-2x.png",
	"n_days_since_first_stream":     "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_happy-twitchiversary_sm-2x.png",
	"n_max_concurrents_m_streams":   "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_the-horde-descends_sm-2x.png",
}

// QuestsBadgeURLMap contains the png urls for the quest specific badges
var QuestsBadgeURLMap = map[string]string{
	"it_begins":         "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_it-begins_sm-2x.png",
	"path_to_affiliate": "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_path-to-affiliate_sm-2x.png",
	"path_to_partner":   "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_path-to-partner_sm-2x.png",
	"vip_badge":         "https://static-cdn.jtvnw.net/cb-achievements-assets/badge_vip_sm-2x.png",
}
