package sourcer

import (
	"context"
	"encoding/json"

	achievement "code.justin.tv/cb/achievements/internal/achievement/nautohost"
	"github.com/pkg/errors"
)

type nAutohostInputMessage struct {
	ChannelID string   `json:"channel_id"`
	NewList   []string `json:"new_list"`
}

func (s *Server) processNAutohostEvent(ctx context.Context, input string) error {
	var message nAutohostInputMessage

	err := json.Unmarshal([]byte(input), &message)
	if err != nil {
		return errors.Wrap(err, "error: failed to parse n_autohost event")
	}

	err = s.sqs.Send(ctx, achievement.Key, &achievement.Input{
		ChannelID: message.ChannelID,
		Count:     len(message.NewList),
	})

	go s.SaveSQSState(achievement.Key, 1)

	if err != nil {
		return errors.Wrap(err, "error: failed to send n_autohost event to worker sqs")
	}

	return nil
}
