package sourcer

import (
	"context"
	"encoding/json"

	"code.justin.tv/cb/achievements/config"
	achievement "code.justin.tv/cb/achievements/internal/achievement/singledashboardvisit"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

type singleDashboardVisitInputMessage struct {
	ChannelID string `json:"channel_id"`
}

func (s *Server) processSingleDashboardVisitEvent(ctx context.Context, input string) error {
	table := config.Values.DynamoDB.Tables.FirstDashboardAccesses
	var message singleDashboardVisitInputMessage

	err := json.Unmarshal([]byte(input), &message)
	if err != nil {
		return errors.Wrap(err, "error: failed to parse single_dashboard_visit event")
	}

	isDuplicate, err := s.dynamoDB.TableHasChannel(ctx, table, message.ChannelID)
	if err != nil {
		return errors.Wrap(err, "error: failed to dedupe single_dashboard_visit event")
	}
	if isDuplicate {
		return nil
	}

	err = s.sqs.Send(ctx, achievement.Key, &achievement.Input{
		ChannelID: message.ChannelID,
	})

	go s.SaveSQSState(achievement.Key, 1)

	if err != nil {
		return errors.Wrap(err, "error: failed to send single_dashboard_visit event to worker sqs")
	}

	go func() {
		err = s.dynamoDB.PersistChannelToTable(context.Background(), table, message.ChannelID)
		if err != nil {
			log.WithError(err).Error("error: failed to cache single_dashboard_visit event to dynamo")
		}
	}()

	return nil
}
