package sourcer

import (
	"context"
	"net/http"

	log "github.com/sirupsen/logrus"
)

func (s *Server) handleTwitchcon(w http.ResponseWriter, r *http.Request) {
	purchasers, err := s.twitchcon.GetPurchasers()
	if err != nil {
		log.WithError(err).Error("sourcer: failed to get twitchcon attendees")
		w.WriteHeader(http.StatusInternalServerError)
		return
	}

	err = s.dbWriter.InsertTwitchconAttendees(context.Background(), purchasers)
	if err != nil {
		log.WithError(err).Error("sourcer: failed to insert twitchcon attendees into db")
		w.WriteHeader(http.StatusInternalServerError)
		return
	}

	w.WriteHeader(http.StatusOK)
}
