package worker

import (
	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/broadcastnhours30days"
	"code.justin.tv/cb/achievements/internal/achievement/firststream"
	"code.justin.tv/cb/achievements/internal/achievement/nautohost"
	"code.justin.tv/cb/achievements/internal/achievement/nbroadcastdays30days"
	"code.justin.tv/cb/achievements/internal/achievement/nconcurrents30days"
	"code.justin.tv/cb/achievements/internal/achievement/ndaysnoviewers"
	"code.justin.tv/cb/achievements/internal/achievement/nfollowers"
	"code.justin.tv/cb/achievements/internal/achievement/nhourslifetime"
	"code.justin.tv/cb/achievements/internal/achievement/nminutewatchedlifetime"
	"code.justin.tv/cb/achievements/internal/achievement/nraidconsecutivebroadcast"
	"code.justin.tv/cb/achievements/internal/achievement/nuniquechatterbroadcast"
	"code.justin.tv/cb/achievements/internal/achievement/nviewerslifetime"
	"code.justin.tv/cb/achievements/internal/achievement/singlebroadcasttitle"
	"code.justin.tv/cb/achievements/internal/achievement/singledashboardvisit"
	"code.justin.tv/cb/achievements/internal/achievement/singleselectgamecommunity"
	"code.justin.tv/cb/achievements/internal/achievement/talkalittle"
)

func (s *Server) newJob(achievementKey string, clients *achievement.Clients, body []byte) achievement.Job {
	job := &achievement.WorkerJob{
		Clients: clients,
	}
	switch achievementKey {
	case broadcastnhours30days.Key:
		job.AchievementJob = broadcastnhours30days.InitJob(clients, body)
	case firststream.Key:
		job.AchievementJob = firststream.InitJob(clients, body)
	case nautohost.Key:
		job.AchievementJob = nautohost.InitJob(clients, body)
	case nbroadcastdays30days.Key:
		job.AchievementJob = nbroadcastdays30days.InitJob(clients, body)
	case nconcurrents30days.Key:
		job.AchievementJob = nconcurrents30days.InitJob(clients, body)
	case ndaysnoviewers.Key:
		job.AchievementJob = ndaysnoviewers.InitJob(clients, body)
	case nfollowers.Key:
		job.AchievementJob = nfollowers.InitJob(clients, body)
	case nhourslifetime.Key:
		job.AchievementJob = nhourslifetime.InitJob(clients, body)
	case nminutewatchedlifetime.Key:
		job.AchievementJob = nminutewatchedlifetime.InitJob(clients, body)
	case nraidconsecutivebroadcast.Key:
		job.AchievementJob = nraidconsecutivebroadcast.InitJob(clients, body)
	case nuniquechatterbroadcast.Key:
		job.AchievementJob = nuniquechatterbroadcast.InitJob(clients, body)
	case talkalittle.Key:
		job.AchievementJob = talkalittle.InitJob(clients, body)
	case nviewerslifetime.Key:
		job.AchievementJob = nviewerslifetime.InitJob(clients, body)
	case singlebroadcasttitle.Key:
		job.AchievementJob = singlebroadcasttitle.InitJob(clients, body)
	case singledashboardvisit.Key:
		job.AchievementJob = singledashboardvisit.InitJob(clients, body)
	case singleselectgamecommunity.Key:
		job.AchievementJob = singleselectgamecommunity.InitJob(clients, body)
	default:
		return nil
	}

	return job
}
