// BUILD

multiJob('cb-achievements-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Build') {
      phaseJob('cb-achievements-build-api') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
      phaseJob('cb-achievements-build-worker') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
      phaseJob('cb-achievements-build-sourcer') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

freeStyleJob('cb-achievements-build-api') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_docker_api.sh'
  }
}

freeStyleJob('cb-achievements-build-worker') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_docker_worker.sh'
  }
}

freeStyleJob('cb-achievements-build-sourcer') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_docker_sourcer.sh'
  }
}

// DEPLOYMENT

multiJob('cb-achievements-deploy') {
  parameters {
    stringParam 'ENVIRONMENT'
    stringParam 'BRANCH'
    stringParam 'GIT_COMMIT'
    stringParam 'SKADI_ID'
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('cb-achievements-deploy-api') {
        killPhaseCondition('FAILURE')
      }
      phaseJob('cb-achievements-deploy-worker') {
        killPhaseCondition('FAILURE')
      }
      phaseJob('cb-achievements-deploy-sourcer') {
        killPhaseCondition('FAILURE')
      }
    }
  }
}

freeStyleJob('cb-achievements-deploy-api') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_beanstalk_api.sh'
  }
}

freeStyleJob('cb-achievements-deploy-worker') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_beanstalk_worker.sh'
  }
}

freeStyleJob('cb-achievements-deploy-sourcer') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/achievements', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_beanstalk_sourcer.sh'
  }
}
