#!/bin/bash
set -e

CONFIG="config/$ENVIRONMENT.yaml"

rm -rf deploy
mkdir -p deploy

echo -e "\033[0;34mCopying application configurations from $CONFIG\033[0m"
cp $CONFIG deploy/config.yaml 2>/dev/null || echo -e "\033[0;31mFailed to copy application config YAML. Proceeding with deployment.\033[0m"

cp -R .ebextensions/global deploy/.ebextensions

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/cb/achievements-worker:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-achievements-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

eb deploy cb-achievements-$ENVIRONMENT-worker \
  --label $ENVIRONMENT-worker-$GIT_COMMIT \
  --message "$BRANCH" \
  --timeout 20 \
  --verbose
