resource "aws_rds_cluster" "main" {
  cluster_identifier              = var.aurora_cluster_identifier
  database_name                   = var.postgres_database_name
  db_cluster_parameter_group_name = "default.aurora-postgresql10"
  db_subnet_group_name            = aws_db_subnet_group.achievements_db_subnet_group.name
  vpc_security_group_ids = [
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  ]

  master_username = "master"
  master_password = "temporary"
  port            = 5432
  engine          = "aurora-postgresql"
  engine_mode     = "provisioned"
  engine_version  = "10.14"
  kms_key_id      = "arn:aws:kms:us-west-2:989470033077:key/75f57e5a-6455-49c0-91e3-1eda073fbbaf"
  availability_zones = [
    "us-west-2a",
    "us-west-2b",
    "us-west-2c",
  ]
  cluster_members = [
    "${var.aurora_cluster_identifier}-primary",
    "${var.aurora_cluster_identifier}-reader",
  ]

  backup_retention_period = 7
  copy_tags_to_snapshot   = true
  deletion_protection     = true
  enable_http_endpoint    = false
  enabled_cloudwatch_logs_exports = [
    "postgresql",
  ]
  iam_database_authentication_enabled = false
  iam_roles                           = []
  preferred_backup_window             = "02:00-04:00"
  preferred_maintenance_window        = var.postgres_maintenance_window
  skip_final_snapshot                 = true
  storage_encrypted                   = true

  tags = {
    Name    = var.name
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }

  timeouts {}
}

resource "aws_rds_cluster_instance" "primary" {
  identifier         = "${var.aurora_cluster_identifier}-primary"
  cluster_identifier = aws_rds_cluster.main.id

  instance_class          = "db.r5.16xlarge"
  engine                  = "aurora-postgresql"
  engine_version          = "10.14"
  promotion_tier          = 1
  availability_zone       = "us-west-2a"
  db_parameter_group_name = "default.aurora-postgresql10"
  db_subnet_group_name    = aws_db_subnet_group.achievements_db_subnet_group.name

  monitoring_role_arn             = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  performance_insights_enabled    = true
  monitoring_interval             = 60
  performance_insights_kms_key_id = "arn:aws:kms:us-west-2:989470033077:key/75f57e5a-6455-49c0-91e3-1eda073fbbaf"

  auto_minor_version_upgrade = true
  ca_cert_identifier         = "rds-ca-2019"
  copy_tags_to_snapshot      = false
  publicly_accessible        = false

  tags = {
    Name    = var.name
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }

  timeouts {}
}

resource "aws_rds_cluster_instance" "reader" {
  identifier         = "${var.aurora_cluster_identifier}-reader"
  cluster_identifier = aws_rds_cluster.main.id

  instance_class          = "db.r5.16xlarge"
  engine                  = "aurora-postgresql"
  engine_version          = "10.14"
  promotion_tier          = 1
  availability_zone       = "us-west-2b"
  db_parameter_group_name = "default.aurora-postgresql10"
  db_subnet_group_name    = aws_db_subnet_group.achievements_db_subnet_group.name

  performance_insights_enabled    = true
  monitoring_interval             = 0
  performance_insights_kms_key_id = "arn:aws:kms:us-west-2:989470033077:key/75f57e5a-6455-49c0-91e3-1eda073fbbaf"

  auto_minor_version_upgrade = true
  ca_cert_identifier         = "rds-ca-2019"
  copy_tags_to_snapshot      = false
  publicly_accessible        = false

  tags = {
    Name    = var.name
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }

  timeouts {}
}
