# Spade streams to ingest into redshift via firehose

data "aws_secretsmanager_secret_version" "redshift_secrets_json" {
  secret_id = "achievements/${var.environment}/redshift"
}

locals {
  redshift_secrets = jsondecode(
    data.aws_secretsmanager_secret_version.redshift_secrets_json.secret_string
  )
}

module "minute_broadcast_stream" {
  source            = "./spade_ingest"
  event_name        = "minute_broadcast-${var.environment}"
  environment       = var.abbreviated_environment_name
  bucket_name       = aws_s3_bucket.data_sink.bucket
  role              = aws_iam_role.firehose.arn
  redshift_username = local.redshift_secrets.username
  redshift_password = local.redshift_secrets.password
  redshift_jdbc_url = var.redshift_jdbc_url

  # TODO: would like a programmatic way to define redshift_tables
  redshift_tables               = ["minute_broadcast"]
  alarm_on_low_number_of_events = 0
}

module "channel_concurrents_stream" {
  source            = "./spade_ingest"
  event_name        = "channel_concurrents-${var.environment}"
  environment       = var.abbreviated_environment_name
  bucket_name       = aws_s3_bucket.data_sink.bucket
  role              = aws_iam_role.firehose.arn
  redshift_username = local.redshift_secrets.username
  redshift_password = local.redshift_secrets.password
  redshift_jdbc_url = var.redshift_jdbc_url

  redshift_tables               = ["channel_concurrents"]
  alarm_on_low_number_of_events = 0
}
