# DynamoDB tables for de-duping one-time events:

resource "aws_dynamodb_table" "first_streams" {
  name             = "${var.name}-${var.environment}-first_streams"
  billing_mode     = "PAY_PER_REQUEST"
  hash_key         = "channel_id"
  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  attribute {
    name = "channel_id"
    type = "S"
  }

  tags = {
    DDBTableGroupKey-Achievements = "Achievements"
  }

  replica {
    region_name = "us-east-2"
  }
}

resource "aws_dynamodb_table" "single-dashboard-visit" {
  name             = "${var.name}-${var.environment}-first_dashboard_accesses"
  billing_mode     = "PAY_PER_REQUEST"
  hash_key         = "channel_id"
  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  attribute {
    name = "channel_id"
    type = "S"
  }

  tags = {
    DDBTableGroupKey-Achievements = "Achievements"
  }

  replica {
    region_name = "us-east-2"
  }
}

resource "aws_dynamodb_table" "channel_updates" {
  name             = "${var.name}-${var.environment}-channel_updates"
  billing_mode     = "PAY_PER_REQUEST"
  hash_key         = "channel_id"
  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  attribute {
    name = "channel_id"
    type = "S"
  }

  tags = {
    DDBTableGroupKey-Achievements = "Achievements"
  }

  replica {
    region_name = "us-east-2"
  }
}

resource "aws_dynamodb_table" "feature_flags" {
  name             = "${var.name}-feature_flags"
  billing_mode     = "PAY_PER_REQUEST"
  hash_key         = "feature_id"
  range_key        = "env"
  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  attribute {
    name = "feature_id"
    type = "S"
  }

  attribute {
    name = "env"
    type = "S"
  }

  tags = {
    DDBTableGroupKey-Achievements = "Achievements"
  }

  replica {
    region_name = "us-east-2"
  }
}
