resource "aws_db_subnet_group" "achievements_db_subnet_group" {
  name        = "achievements-db-subnet-${var.environment}"
  description = "DB Subnet group"

  # Private subnets comes back from the AWS API in a seemingly random order
  # and this prevents unnecessary changes to Beanstalk environments.
  subnet_ids = split(",", data.terraform_remote_state.account.outputs.private_subnets)
}

resource "aws_db_instance" "master" {
  engine            = "postgres"
  engine_version    = "10.15" # RDS automatically upgrades this and it has to be manually kept in sync
  instance_class    = var.postgres_instance_type
  storage_type      = "io1"
  iops              = var.postgres_iops
  allocated_storage = var.postgres_storage
  multi_az          = false

  identifier = var.postgres_master_identifier
  name       = "achievements"
  username   = "master"
  password   = "temporary"

  publicly_accessible = false

  vpc_security_group_ids = [
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  ]

  port                         = 5432
  db_subnet_group_name         = aws_db_subnet_group.achievements_db_subnet_group.name
  parameter_group_name         = var.postgres_parameter_group
  monitoring_interval          = 5
  monitoring_role_arn          = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  performance_insights_enabled = true

  backup_retention_period         = 1
  backup_window                   = "02:00-04:00"
  enabled_cloudwatch_logs_exports = ["postgresql"]
  skip_final_snapshot             = false
  maintenance_window              = var.postgres_maintenance_window

  tags = {
    Name    = var.name
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }
}

resource "aws_db_instance" "replica" {
  replicate_source_db = aws_db_instance.master.id

  instance_class    = var.postgres_instance_type
  storage_type      = "io1"
  iops              = var.postgres_iops
  allocated_storage = var.postgres_replica_storage

  identifier = var.postgres_replica_identifier
  name       = aws_db_instance.master.name

  publicly_accessible = false

  vpc_security_group_ids = [
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  ]

  port                         = aws_db_instance.master.port
  parameter_group_name         = var.postgres_parameter_group
  monitoring_interval          = 5
  monitoring_role_arn          = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  performance_insights_enabled = true

  enabled_cloudwatch_logs_exports = ["postgresql"]
  skip_final_snapshot             = true
  maintenance_window              = var.postgres_maintenance_window

  tags = {
    Name    = var.name
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }
}
