resource "aws_s3_bucket" "data_sink" {
  bucket = "${var.name}-${var.environment}-data-sink"
  acl    = "private"
}

resource "aws_s3_bucket" "redshift_logs" {
  bucket = "${var.name}-${var.environment}-redshift-logs"
  acl    = "private"

  policy = <<EOF
{
	"Version": "2012-10-17",
	"Statement": [
		{
			"Sid": "Put",
			"Effect": "Allow",
			"Principal": {
				"AWS": "arn:aws:iam::902366379725:user/logs"
			},
			"Action": "s3:PutObject",
			"Resource": [
				"arn:aws:s3:::${var.name}-${var.environment}-redshift-logs/*",
				"arn:aws:s3:::${var.name}-${var.environment}-redshift-logs"
			]
		},
		{
			"Sid": "Get",
			"Effect": "Allow",
			"Principal": {
				"AWS": "arn:aws:iam::902366379725:user/logs"
			},
			"Action": "s3:GetBucketAcl",
			"Resource": [
				"arn:aws:s3:::${var.name}-${var.environment}-redshift-logs/*",
				"arn:aws:s3:::${var.name}-${var.environment}-redshift-logs"
			]
		}
	]
}
EOF
}

#TODO set expiration policy on prefix

