# Worker SNS Topics
resource "aws_sns_topic" "notify-achievement-complete" {
  name = "${var.name}-${var.environment}-achievement-completed"
}

resource "aws_sns_topic" "notify-quest-complete" {
  name = "${var.name}-${var.environment}-quest-completed"
}

# Sourcer SNS topics

# Create a SNS topic that we will subscribe to in our sourcer SQS
# Ingest team will use this provided topic to notify us of stream up
resource "aws_sns_topic" "notify-video-ingest-stream" {
  name = "${var.team_abbreviation}-video-ingest-stream-notifications"
}

resource "aws_sns_topic_policy" "notify-video-ingest-stream-policy" {
  arn = aws_sns_topic.notify-video-ingest-stream.arn

  policy = <<POLICY
{
  "Version": "2008-10-17",
  "Id": "${aws_sns_topic.notify-video-ingest-stream.arn}/SNSPolicy",
  "Statement": [
    {
      "Sid": "notify-video-ingest-stream",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::116501376633:role/notifications-stream_event"
      },
      "Action": "SNS:Publish",
      "Resource": "${aws_sns_topic.notify-video-ingest-stream.arn}"
    }
  ]
}
POLICY
}

# Dashy Dashboard Access SNS topic replacement
resource "aws_sns_topic" "stream-manager-visited" {
  name = "${var.name}-${var.environment}-stream-manager-visited"
}
