resource "aws_kinesis_firehose_delivery_stream" "stream" {
  count       = length(var.redshift_tables)
  name        = "spade-downstream-prod-${var.team_name}-${var.environment}-${element(var.redshift_tables, count.index)}"
  destination = "redshift"

  s3_configuration {
    bucket_arn         = "arn:aws:s3:::${var.bucket_name}"
    role_arn           = var.role
    prefix             = "firehose/${var.event_name}/"
    buffer_size        = 10
    buffer_interval    = 60
    compression_format = "GZIP"

    cloudwatch_logging_options {
      enabled         = "true"
      log_group_name  = aws_cloudwatch_log_group.firehose-log-group[count.index].name
      log_stream_name = aws_cloudwatch_log_stream.firehose-log-stream-s3[count.index].name
    }
  }

  redshift_configuration {
    role_arn        = var.role
    cluster_jdbcurl = var.redshift_jdbc_url
    username        = var.redshift_username
    password        = var.redshift_password
    data_table_name = "logs.${element(var.redshift_tables, count.index)}"
    copy_options    = "GZIP json 'auto' truncatecolumns roundec compupdate on emptyasnull acceptinvchars '?' trimblanks"

    cloudwatch_logging_options {
      enabled         = "true"
      log_group_name  = aws_cloudwatch_log_group.firehose-log-group[count.index].name
      log_stream_name = aws_cloudwatch_log_stream.firehose-log-stream-redshift[count.index].name
    }
  }
}
