variable "account_id" {
  type        = string
  default     = "989470033077"
  description = "AWS account id"
}

variable "aws_key_name" {
  type    = string
  default = "creator-business"
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "eb_api_asg_max_size" {
  type        = string
  description = "Largest size that the Elastic Beanstalk API environment's cluster will grow to"
}

variable "eb_api_asg_min_size" {
  type        = string
  description = "Smallest size size that the Elastic Beanstalk API environment's cluster will shrink down to"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "cb-achievements"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "team_abbreviation" {
  type        = string
  default     = "cb"
  description = "Shorthand for Creator Business"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "cb/achievements"
  description = "GitHub repository name"
}

variable "root_volume_size" {
  type        = string
  default     = 256
  description = "Amount of diskspace allocated to the root drive (GB)"
}

variable "sandstorm_iam_role_arn" {
  type        = string
  description = "AWS IAM Role ARN for assuming the role of the Sandstorm Agent"
}

variable "solution_stack_name" {
  type    = string
  default = "64bit Amazon Linux 2018.03 v2.16.5 running Docker 19.03.13-ce"
}

variable "team" {
  type        = string
  default     = "Creator Business"
  description = "Twitch team name"
}

variable "sqs_defaults" {
  type = map(any)

  default = {
    visibility_timeout_seconds     = 60
    message_retention_seconds      = 7200   # 2 hours
    dead_message_retention_seconds = 345600 # 4 days
  }
}

variable "worker_connection_timeouts" {
  type = map(any)

  default = {
    default    = 60
    affiliates = 100
    sourcer    = 1800
    quests     = 1800
  }
}

# Redshift Vars
variable "redshift_automated_snapshot_retention_period" {
  type        = string
  description = "Retention period for automated redshift snapshots"
}

variable "redshift_master_username" {
  type        = string
  default     = "cb"
  description = "Redshift master username"
}

# TODO: retrieve this from sandstorm once password is secure
variable "redshift_temporary_password" {
  type        = string
  default     = "Temp_Password_1"
  description = "Temporary redshift password"
}

variable "redshift_cluster_identifier" {
  type        = string
  description = "Redshift cluster identifier"
}

variable "redshift_database_name" {
  type        = string
  description = "Redshift database name"
}

# TODO: we should get this from remote .tfstate file instead of hardcoding this in environments
variable "redshift_jdbc_url" {
  type        = string
  description = "JDBC URL to the target Redshift cluster. It can be found on the Redshift console."
}

variable "abbreviated_environment_name" {
  type        = string
  description = "Suffix for firehose stream name, shortened to avoid char limits"
}

# SNS topics to subscribe by sourcer_queue
variable "sns_topic_users_service_channel_mutation" {
  type        = string
  description = "topic arn for users-service update_channel_mutation event sns topic"
}

variable "sns_topic_autohost_list_updates" {
  type        = string
  description = "topic arn for autohost_list_updates sns topic"
}

variable "sns_topic_zuma_channel_select_community" {
  type        = string
  description = "topic arn for zuma channel_select_community"
}

variable "sns_topic_affiliates_onboarding_status" {
  type        = string
  description = "topic arn for affiliates onboarding status updates"
}

variable "postgres_instance_type" {
  type        = string
  default     = "db.r5.24xlarge"
  description = "instance type of the rds cluster"
}

variable "postgres_iops" {
  type    = string
  default = 80000
}

variable "postgres_maintenance_window" {
  type    = string
  default = "wed:20:00-wed:20:30"
}

variable "postgres_master_identifier" {
  type = string
}

variable "postgres_replica_identifier" {
  type = string
}

variable "postgres_parameter_group" {
  type        = string
  description = "name of the parameter group to use for rds"
}

variable "postgres_storage" {
  type    = string
  default = 3000
}

variable "postgres_replica_storage" {
  type    = string
  default = 3000
}

variable "postgres_database_name" {
  type    = string
  default = "achievements"
}

variable "aurora_cluster_identifier" {
  type = string
}

# VPC Endpoint Service Variables
variable "vpc_endpoint_service_allowed_principals" {
  type        = list(any)
  description = "the arns that are whitelisted to access the VPC endpoint service"
}

variable "vpc_endpoint_caller_tailwind" {
  type        = string
  default     = "tailwind"
  description = "VPC endpoint service caller"
}
