resource "aws_cloudwatch_metric_alarm" "api_health" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-api-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS application"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    EnvironmentName = "${var.team_code}-${var.name}-${var.environment}-api"
  }
}

resource "aws_cloudwatch_metric_alarm" "sourcer_health" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-sourcer-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS application"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    EnvironmentName = "${var.team_code}-${var.name}-${var.environment}-sourcer"
  }
}

resource "aws_cloudwatch_metric_alarm" "worker_health" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-worker-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS application"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    EnvironmentName = "${var.team_code}-${var.name}-${var.environment}-worker"
  }
}

resource "aws_cloudwatch_metric_alarm" "redshift_disk_space" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-redshift-disk-space"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "PercentageDiskSpaceUsed"
  namespace                 = "AWS/Redshift"
  period                    = "300"
  statistic                 = "Average"
  threshold                 = "95"
  alarm_description         = "Monitors the disk usage of the achievements redshift cluster"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    ClusterIdentifier = "${var.team_code}-${var.name}-${var.environment}"
  }
}

resource "aws_cloudwatch_metric_alarm" "redshift_query_time" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-redshift-query-time"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "6"
  metric_name               = "QueryDuration"
  namespace                 = "AWS/Redshift"
  period                    = "300"
  statistic                 = "Maximum"
  threshold                 = "1800000000"
  alarm_description         = "Monitors the execution time of queries on the achievements tahoe replica"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    latency           = "long"
    NodeID            = "Leader"
    ClusterIdentifier = "${var.team_code}-${var.name}-${var.environment}-tahoe-replica"
  }
}

resource "aws_cloudwatch_metric_alarm" "redshift_query_count" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-redshift-query-count"
  comparison_operator       = "LessThanOrEqualToThreshold"
  evaluation_periods        = "20"
  metric_name               = "QueriesCompletedPerSecond"
  namespace                 = "AWS/Redshift"
  period                    = "300"
  statistic                 = "Average"
  threshold                 = "0"
  alarm_description         = "Monitors the amount of queries completed in the achievements tahoe replica"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    latency           = "long"
    NodeID            = "Leader"
    ClusterIdentifier = "${var.team_code}-${var.name}-${var.environment}-tahoe-replica"
  }
}

resource "aws_cloudwatch_metric_alarm" "rds_free_storage_space" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-rds_free_storage_space"
  comparison_operator       = "LessThanOrEqualToThreshold"
  evaluation_periods        = "1"
  metric_name               = "FreeStorageSpace"
  namespace                 = "AWS/RDS"
  period                    = "60"
  statistic                 = "Average"
  threshold                 = "50000000000" # 50gb
  alarm_description         = "Monitors the amount of free storage space in the achievements rds instance"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}-5"
  }
}

resource "aws_cloudwatch_metric_alarm" "rds_cpu_utilization" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-rds_cpu_utilization"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "5"
  metric_name               = "CPUUtilization"
  namespace                 = "AWS/RDS"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "65"
  alarm_description         = "Monitors the cpu utilization in the achievements rds instance"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}-5"
  }
}

resource "aws_cloudwatch_metric_alarm" "rds_read_iops" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-rds_read_iops"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "10"
  metric_name               = "ReadIOPS"
  namespace                 = "AWS/RDS"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "45000"
  alarm_description         = "Monitors the read iops in the achievements rds instance"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns
  datapoints_to_alarm       = 10

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}-5"
  }
}

resource "aws_cloudwatch_metric_alarm" "rds_write_iops" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-rds_write_iops"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "10"
  metric_name               = "WriteIOPS"
  namespace                 = "AWS/RDS"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "45000"
  alarm_description         = "Monitors the write iops in the achievements rds instance"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}-5"
  }
}

resource "aws_cloudwatch_metric_alarm" "channel_concurrents_firehose_delivery_to_redshift_success" {
  alarm_name          = "${var.team_code}-${var.name}-${var.environment}-channel_concurrents_firehose_delivery_to_redshift_success"
  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = "3"
  metric_name         = "DeliveryToRedshift.Success"
  namespace           = "AWS/Firehose"
  period              = "300"
  statistic           = "Average"
  threshold           = "0.9"
  alarm_description   = "Monitors the success rate of copying channel_concurrents firehose events to redshift"
  treat_missing_data  = "breaching"
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns
  insufficient_data_actions = []

  dimensions = {
    DeliveryStreamName = "spade-downstream-prod-${var.team_code}-${var.abbreviated_name}-${var.abbreviated_environment_name}-channel_concurrents"
  }
}

resource "aws_cloudwatch_metric_alarm" "minute_broadcast_firehose_delivery_to_redshift_success" {
  alarm_name          = "${var.team_code}-${var.name}-${var.environment}-minute_broadcast_firehose_delivery_to_redshift_success"
  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = "3"
  metric_name         = "DeliveryToRedshift.Success"
  namespace           = "AWS/Firehose"
  period              = "300"
  statistic           = "Average"
  threshold           = "0.9"
  alarm_description   = "Monitors the success rate of copying minute_broadcast firehose events to redshift"
  treat_missing_data  = "breaching"
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns
  insufficient_data_actions = []

  dimensions = {
    DeliveryStreamName = "spade-downstream-prod-${var.team_code}-${var.abbreviated_name}-${var.abbreviated_environment_name}-minute_broadcast"
  }
}

resource "aws_cloudwatch_metric_alarm" "worker-queue-delayed" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-worker-queue-delayed"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "10"
  metric_name               = "ApproximateAgeOfOldestMessage"
  namespace                 = "AWS/SQS"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "3600"
  alarm_description         = "Monitors the worker queue to ensure that persisting achievement progress does not fall behind"
  treat_missing_data        = "breaching"
  insufficient_data_actions = []
  alarm_actions             = var.alert_arns
  ok_actions                = var.alert_arns

  dimensions = {
    QueueName = "${var.team_code}-${var.name}-${var.environment}-worker-queue"
  }
}
