variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "achievements"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "abbreviated_name" {
  type        = string
  default     = "ach"
  description = "Name used for Kinesis Firehose upstream"
}

variable "abbreviated_environment_name" {
  type        = string
  description = "Suffix for firehose stream name, shortened to avoid char limits"
}

variable "alert_arns" {
  type        = list
  description = "SNS topics for alert notifications when an alarm is triggered in cloudwatch"
}

variable "team_code" {
  type    = string
  default = "cb"
}
