# Get the latest amazon linux 2 x64 ami
data "aws_ami" "amazon" {
  most_recent = true
  filter {
    name   = "name"
    values = ["amzn2-ami-hvm-2.0.*-x86_64-gp2"]
  }

  filter {
    name   = "virtualization-type"
    values = ["hvm"]
  }

  owners = ["137112412989"]
}

resource "aws_instance" "BastionHost" {
  ami           = data.aws_ami.amazon.id
  instance_type = "t3.nano"

  tags = {
    Name = "BastionHost"
  }

  // Install SSM
  user_data = file("${path.module}/user_data.sh")

  vpc_security_group_ids = var.security_group_ids
  subnet_id              = var.subnet_ids[0]

  iam_instance_profile = aws_iam_instance_profile.bastion_host_profile.name

  lifecycle {
    create_before_destroy = true
  }
}
