package main

import (
	"fmt"
	"log"
	"net/http"
	"os"
	"time"

	"code.justin.tv/cb/achievements/validator/cli/lambda"
	"code.justin.tv/cb/achievements/validator/model/query"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/urfave/cli"
)

const (
	awsRegion    = "us-west-2"
	logGroupName = "staging-Achievements-CleanTapValidator-TaskContainerLogGroup81313363-ul26w6g1I5OM"
	timeout      = 3 * time.Minute
)

func main() {
	sess, err := session.NewSession(&aws.Config{
		HTTPClient: &http.Client{
			Timeout: timeout,
		},
		Region: aws.String(awsRegion),
	})
	if err != nil {
		log.Panicf("create new session: %+v", err)
	}

	lambdaClient := lambda.NewClient(sess)

	app := cli.NewApp()
	app.Name = "validator"
	app.Usage = "Run queries against Clean and Dirty Tahoe taps and verify that query results match. Type 'validator help' for more details."
	app.Commands = make([]cli.Command, 0, len(query.Names))
	for _, queryName := range query.Names {
		app.Commands = append(app.Commands, cli.Command{
			Name: string(queryName),
			Action: func(c *cli.Context) error {
				err := lambdaClient.RunValidator(query.Name(c.Command.Name))
				if err != nil {
					panic(fmt.Errorf("run lambda validator: %w", err))
				}

				log.Printf("started validator task for query: %s", c.Command.Name)
				log.Printf("see logs in Cloudwatch: %s", logGroupName)
				return nil
			},
		})
	}

	err = app.Run(os.Args)
	if err != nil {
		log.Panicf(fmt.Sprintf("run cli app: %v", err))
	}
}
