package logger

import (
	"fmt"

	"code.justin.tv/cb/achievements/validator/model/query"
)

type Logger interface {
	Print(msg string)
	Error(msg string) error
	Errorf(msg string, err error) error
	Panicf(msg string, err error)
}

type client struct {
	queryName query.Name
}

func NewClient(queryName query.Name) Logger {
	return &client{
		queryName: queryName,
	}
}

func (c *client) Print(msg string) {
	fmt.Printf("%s: %s\n", c.queryName, msg)
}

func (c *client) Error(msg string) error {
	return fmt.Errorf("%s: %s", c.queryName, msg)
}

func (c *client) Errorf(msg string, err error) error {
	return fmt.Errorf("%s: %s: %w", c.queryName, msg, err)
}

func (c *client) Panicf(msg string, err error) {
	panic(fmt.Sprintf("%s: %s: %v", c.queryName, msg, err))
}
