package validator

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/achievements/internal/clients/redshift"
)

// TODO: This is an example

func (c *client) BroadcastNHours30Days(ctx context.Context) error {
	// minutesThreshold set to 0 in sourcer
	minutesThreshold := 0

	now := time.Now()
	dirtyQueryResults, err := c.dirtyClient.BroadcastNHours30Days(ctx, minutesThreshold)
	if err != nil {
		return c.logger.Errorf("dirty query", err)
	}

	dirtyQueryDuration := time.Since(now).Milliseconds()
	c.logger.Print(fmt.Sprintf("dirty query duration: %d ms", dirtyQueryDuration))

	now = time.Now()
	cleanQueryResults, err := c.cleanClient.BroadcastNHours30Days(ctx, minutesThreshold)
	if err != nil {
		return c.logger.Errorf("clean query", err)
	}

	cleanQueryDuration := time.Since(now).Milliseconds()
	c.logger.Print(fmt.Sprintf("clean query duration: %d ms", cleanQueryDuration))

	err = validateBroadcastNHours30Days(dirtyQueryResults, cleanQueryResults)
	if err != nil {
		return c.logger.Errorf("dirty and clean results are not equal", err)
	}

	c.logger.Print("validated!")
	return nil
}

func validateBroadcastNHours30Days(dirty, clean []*redshift.MinutesBroadcastAggregate) error {
	if len(dirty) != len(clean) {
		return fmt.Errorf("number of rows in query results are not equal, dirty has %d but clean has %d", len(dirty), len(clean))
	}

	for i := 0; i < len(dirty); i++ {
		if dirty[i] == nil && clean[i] == nil {
			continue
		}

		if dirty[i] == nil || clean[i] == nil {
			return fmt.Errorf("row# %d is not equal, dirty is %+v but clean is %+v", i, dirty[i], clean[i])
		}

		if dirty[i].ChannelID != clean[i].ChannelID {
			return fmt.Errorf("row# %d ChannelID is not equal, dirty is %s but clean is %s", i, dirty[i].ChannelID, clean[i].ChannelID)
		}

		if dirty[i].Minutes != clean[i].Minutes {
			return fmt.Errorf("row# %d Minutes is not equal, dirty is %d but clean is %d", i, dirty[i].Minutes, clean[i].Minutes)
		}
	}

	return nil
}
