package validator

import (
	"context"

	"code.justin.tv/cb/achievements/internal/clients/redshift"
	"code.justin.tv/cb/achievements/validator/task/logger"
)

type Validator interface {
	BroadcastNHours30Days(ctx context.Context) error
}

type client struct {
	cleanClient *redshift.Client
	dirtyClient *redshift.Client

	logger logger.Logger
}

type Params struct {
	CleanClient *redshift.Client
	DirtyClient *redshift.Client

	Logger logger.Logger
}

func NewClient(p Params) (Validator, error) {
	return &client{
		cleanClient: p.CleanClient,
		dirtyClient: p.DirtyClient,
		logger:      p.Logger,
	}, nil
}
