package view

import "time"

// Achievements is the response for GET /v1/channel/:channel_id/viewer/:viewer_id/achievements.
type Achievements struct {
	Achievements []*Achievement `json:"achievements"`
}

// Achievement is an achievement with a channel's progression,
type Achievement struct {
	ID          string     `json:"id"`
	Key         string     `json:"key"`
	Level       int        `json:"level"`
	Progress    int        `json:"progress"`
	ProgressCap int        `json:"progress_cap"`
	Image       string     `json:"image"`
	ImageSm     string     `json:"image-sm"`
	Image2x     string     `json:"image-2x"`
	Image3x     string     `json:"image-3x"`
	CompletedAt *time.Time `json:"completed_at"`
}
