# module "account_template" {
#   source = "modules/account_template"
#   credential_profile = "twitch-cb-aws"
#   account_name = "twitch-cb-aws"
#   vpc_cidr = "10.201.228.0/22"
#   owner = "creatorbusiness@twitch.tv"
# }

resource "aws_s3_bucket" "account" {
  bucket = "twitch-cb-aws"
  acl = "private"
}

resource "aws_s3_bucket_object" "object" {
  bucket = "${aws_s3_bucket.account.bucket}"
  key    = "tfstate/account"
  content = <<EOF
  {
    "version": 1,
    "serial": 1,
    "remote": {
      "type": "s3",
      "config": {
        "bucket": "twitch-cb-aws",
        "key": "tfstate/twitch-cb-aws"
      }
    },
    "modules": [
      {
        "path": [
          "root"
        ],
        "outputs": {
          "private_subnets": "subnet-6f4a7808,subnet-45e7ad0c,subnet-86fe23dd",
          "public_subnets": "subnet-62497b05,subnet-58fab011,subnet-6ffc2134",
          "twitch_subnets_sg": "sg-57251d2c",
          "vpc_id": "vpc-7851b71e"
        }
      }
    ]
  }
EOF

}
