#!/bin/sh

set -e

echo "Downloading Sandstorm-Agent"
yum-config-manager -y --enable artifactory
yum clean all
yum install -y sandstorm-agent || echo "failed to install sandstorm-agent"

eval  $(/opt/elasticbeanstalk/containerfiles/support/generate_env | sed 's/$/;/')

# Substitude sandstorm role in config file
sed -i "s|{SANDSTORM_IAM_ROLE_ARN}|$SANDSTORM_IAM_ROLE_ARN|g" /etc/sandstorm-agent/conf.d/01-agent-config.conf

# Substitude env values into template files
sed -i "s|{SANDSTORM_CARTMAN_KEY}|${SANDSTORM_CARTMAN_KEY}|g" /etc/sandstorm-agent/templates.d/cartman-ecc-public-key
sed -i "s|{SANDSTORM_ROLLBAR_TOKEN_KEY}|${SANDSTORM_ROLLBAR_TOKEN_KEY}|g" /etc/sandstorm-agent/templates.d/rollbar-token
sed -i "s|{SANDSTORM_DB_KEY}|${SANDSTORM_DB_KEY}|g" /etc/sandstorm-agent/templates.d/secrets

echo "Setting Up Monit"

mkdir -p /var/lib/monit

monit
sleep 5
monit reload
sleep 5

echo "Restarting Sandstorm-Agent"

monit restart sandstorm-agent

# Clean Up
