# Dashy

**THIS SERVICE IS SHUTDOWN**

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=cb-dashy-build)](https://jenkins.internal.justin.tv/job/cb-dashy-build)

Dashy is a Go web service that provides most of the APIs for Channel Analytics, Stream Summary, and Team Stats Dashboard.

[Wiki](https://wiki.twitch.com/display/CB/Dashy) | [Runbook](./docs/runbook.md) | [Grafana](https://grafana.internal.justin.tv/d/7J8qK_zWk/ca-dashy) | [SLA](./docs/service_level_agreement.md)

## Getting Started

All dependencies are version-controlled in the `vendor/` directory using [`dep`](https://golang.github.io/dep/).

```sh
brew install dep
```

To use the dep CLI tool:

```sh
dep ensure
```

### Running Server Locally

Make sure `twitch-dashy-dev` isengard credentials exist within your aws credentials file.

```.env
export AWS_PROFILE=twitch-dashy-dev
``` 

Start the server.
```sh
make dev
```

You can use `authtoken` to generate a JWT for requests to your local server.

```sh
./authtoken 24991333 view_stats
```

Copy the generated auth token and supply it as the `Twitch-Authorization` header.

```sh
curl -X GET -H "Twitch-Authorization:<AUTH_TOKEN>" "http://localhost:8000/v1/stats/channels/24991333/followers?end_time=2019-03-20T06:59:59Z&start_time=2019-01-19T08:00:00Z"
```

## Testing

The `Makefile` `make test` command runs `go test` on the application packages, avoiding `vendor/`.

## Linting

The `Makefile` `make lint` command uses a series of linter tools for the project:

- [gofmt](https://golang.org/cmd/gofmt/)

- [go vet](https://golang.org/cmd/vet/)

- [errcheck](https://github.com/kisielk/errcheck)

- [aligncheck, structcheck, and varcheck](https://github.com/opennota/check)

Installing [golangci-lint](https://github.com/golangci/golangci-lint) includes the above tools plus more.

It is _highly_ recommended that you install a Go linter plugin for your editor.
