CREATE TABLE feedbacks(
  id SERIAL PRIMARY KEY,
  user_id int NOT NULL,
  comment varchar(2000) NOT NULL CONSTRAINT feedbacks_comment_not_empty CHECK (comment <> ''),
  created_at timestamp DEFAULT current_timestamp NOT NULL
);

CREATE UNIQUE INDEX feedbacks_user_id_and_created_at_uniq_idx on feedbacks (user_id, created_at);
CREATE INDEX feedbacks_created_at_idx on feedbacks (created_at);
CREATE INDEX feedbacks_user_id_idx on feedbacks (user_id);