#!/bin/bash
set -e

GIT_COMMIT=$1
ENVIRONMENT=$2
JOB_NAME=$3
CONFIG="config/$ENVIRONMENT.json"

rm -rf deploy
mkdir -p deploy

echo "Copying application configurations from $CONFIG"
cp $CONFIG deploy/config.json 2>/dev/null || (echo -e "\033[0;31mFailed to copy application config JSON. Aborting.\033[0m" && exit)

cp -R .ebextensions/ deploy/.ebextensions

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker-registry.internal.justin.tv/cb/dashy:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
  global:
    application_name: dashy-alb
    default_region: us-west-2
EOF

eb deploy dashy-live --label $JOB_NAME-$GIT_COMMIT --verbose --timeout 30
