package dashy

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/dashy/view/chat"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1ChatActivityByTime makes a GET request to the Dashy Service for
// chat activity metrics
func (c *client) GetV1ChatActivityByTime(ctx context.Context, params *chat.GetV1ChatActivityByTimeReqParams, reqOpts *twitchclient.ReqOpts) (*chat.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/stats/channels/%s/chat_activity", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Add("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Add("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_chat_activity_by_time",
		StatSampleRate: 0.1,
	})

	response := &chat.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
