package dashy

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/dashy/view/clips"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1ClipsByTime makes a GET request to the Dashy Service for a
// collection of Clips activities within a time range
func (c *client) GetV1ClipsByTime(ctx context.Context, params *clips.GetV1ClipsByTimeReqParams, reqOpts *twitchclient.ReqOpts) (*clips.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/stats/channels/%s/clips", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Add("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Add("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_clips_by_time",
		StatSampleRate: 0.1,
	})

	response := &clips.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
