package dashy

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/dashy/view/followers"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1FollowersByTime makes a GET request to the Dashy Service for a
// collection of follower activities within a time range
func (c *client) GetV1FollowersByTime(ctx context.Context, params *followers.GetV1FollowersByTimeReqParams, reqOpts *twitchclient.ReqOpts) (*followers.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/stats/channels/%s/followers", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Add("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Add("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_followers_by_time",
		StatSampleRate: 0.1,
	})

	response := &followers.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
