package dashy

import (
	"context"
	"fmt"

	"code.justin.tv/cb/dashy/view/layout"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1LayoutPreferences makes a GET request to the Dashy Service for
// a user's live dashboard layout preferences
func (c *client) GetV1LayoutPreferences(ctx context.Context, params *layout.GetV1LayoutPreferencesParams, reqOpts *twitchclient.ReqOpts) (*layout.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/dashboard/channels/%s/layout", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_layout_preferences",
		StatSampleRate: 0.1,
	})

	response := &layout.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
