package dashy

import (
	"context"
	"net/http"
	"strings"
	"time"

	"code.justin.tv/cb/dashy/view/multichannel"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1MultiChannelChatActivitiesByTimeReqParams contains
// the required parameters to make the
// GET /v1/stats/multi_channel/chat_activities request.
type GetV1MultiChannelChatActivitiesByTimeReqParams struct {
	ChannelIDs []string
	StartTime  time.Time
	EndTime    time.Time
}

// GetV1MultiChannelChatActivitiesByTime makes a GET request
// to the Dashy service for the chat activities
// of one or more channels, given a time range.
func (c *client) GetV1MultiChannelChatActivitiesByTime(ctx context.Context, params *GetV1MultiChannelChatActivitiesByTimeReqParams, reqOpts *twitchclient.ReqOpts) (*multichannel.ChatActivitiesResponse, error) {
	path := "/v1/stats/multi_channel/chat_activities"

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Set("channel_ids", strings.Join(params.ChannelIDs, ","))
	query.Set("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Set("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_multi_channel_chat_activities",
		StatSampleRate: 0.1,
	})

	response := &multichannel.ChatActivitiesResponse{}
	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
