package dashy

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/dashy/view/raid"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1RaidActivityByTime makes a GET request to the Dashy Service for
// raid activity metrics
func (c *client) GetV1RaidActivityByTime(ctx context.Context, params *raid.GetV1RaidActivityTimeReqParams, reqOpts *twitchclient.ReqOpts) (*raid.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/stats/channels/%s/raids_activity", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Add("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Add("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_raids_activity_by_time",
		StatSampleRate: 0.1,
	})

	response := &raid.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
