package dashy

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/dashy/view/subscriptionpurchase"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1SubscriptionPurchaseSuccessByTime makes a GET request to the Dashy Service for
// subscription purchase activity metrics
func (c *client) GetV1SubscriptionPurchaseSuccessByTime(ctx context.Context, params *subscriptionpurchase.GetV1SubscriptionPurchaseActivityTimeReqParams, reqOpts *twitchclient.ReqOpts) (*subscriptionpurchase.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/stats/channels/%s/subscription_purchase", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Add("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Add("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_subscription_purchase_success_by_time",
		StatSampleRate: 0.1,
	})

	response := &subscriptionpurchase.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
