package dashy

import (
	"context"
	"fmt"

	"code.justin.tv/cb/dashy/view/tagfilters"
	"code.justin.tv/foundation/twitchclient"
)

func (c *client) GetV1TagFilters(ctx context.Context, channelID int64, reqOpts *twitchclient.ReqOpts) (*tagfilters.Response, error) {
	path := fmt.Sprintf("v1/dashboard/channels/%d/tag_filters", channelID)
	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_tag_filters",
		StatSampleRate: 1.0,
	})

	response := &tagfilters.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
