package dashy

import (
	"context"
	"encoding/json"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/cb/dashy/view/tagfilters"
	"code.justin.tv/foundation/twitchclient"
	"github.com/stretchr/testify/suite"
)

type GetV1TagFiltersSuite struct {
	suite.Suite
}

func TestGetV1TagFiltersSuite(t *testing.T) {
	suite.Run(t, &GetV1TagFiltersSuite{})
}

func (suite *GetV1TagFiltersSuite) TestSuccess() {
	channelID := int64(7890)

	response := tagfilters.Response{
		Status: http.StatusOK,
		Data: tagfilters.Data{
			ChannelID: channelID,
			Tags: []tagfilters.Tag{
				{
					TagID:      "qwe",
					Percentage: 0.6,
				},
				{
					TagID:      "asd",
					Percentage: 0.4,
				},
			},
		},
	}

	server := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		suite.Equal("/v1/dashboard/channels/7890/tag_filters", r.URL.EscapedPath())

		w.WriteHeader(http.StatusOK)

		body, err := json.Marshal(response)
		suite.NoError(err)

		_, err = w.Write(body)
		suite.NoError(err)
	}))

	defer server.Close()

	client, err := NewClient(twitchclient.ClientConf{
		Host: server.URL,
	})
	suite.NoError(err)

	resp, err := client.GetV1TagFilters(context.Background(), channelID, nil)
	suite.Nil(err)
	suite.NotNil(resp)

	suite.Equal(resp.Status, 200)
	suite.Equal(resp.Message, "")
	suite.Equal(resp.Data.ChannelID, channelID)
	suite.Equal(len(resp.Data.Tags), 2)
}

func (suite *GetV1TagFiltersSuite) TestFailure() {
	server := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(http.StatusInternalServerError)
	}))

	defer server.Close()

	client, err := NewClient(twitchclient.ClientConf{
		Host: server.URL,
	})
	suite.NoError(err)

	resp, err := client.GetV1TagFilters(context.Background(), 7890, nil)
	suite.NotNil(err)
	suite.Nil(resp)
}
