package dashy

import (
	"context"

	"code.justin.tv/cb/dashy/view/tips"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1ClipsByTime makes a GET request to the Dashy Service for a
// random tip in the given language
func (c *client) GetV1Tip(ctx context.Context, language string, reqOpts *twitchclient.ReqOpts) (*tips.Response, error) {
	req, err := c.NewRequest("GET", "/v1/stream_summary/tip", nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Language", language)

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_tip",
		StatSampleRate: 1.0,
	})

	response := &tips.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
