package dashy

import (
	"context"
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/foundation/twitchclient"
	"github.com/stretchr/testify/suite"
)

type GetV1TipSuite struct {
	suite.Suite
}

func TestGetV1TipSuite(t *testing.T) {
	suite.Run(t, &GetV1TipSuite{})
}

func (suite *GetV1TipSuite) TestFailure() {
	server := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(http.StatusInternalServerError)
	}))

	defer server.Close()

	client, err := NewClient(twitchclient.ClientConf{
		Host: server.URL,
	})
	suite.NoError(err)

	language := "th"

	resp, err := client.GetV1Tip(context.Background(), language, nil)
	suite.NotNil(err)
	suite.Nil(resp)
}

func (suite *GetV1TipSuite) TestSuccess() {
	body := "You should stream often"
	url := "https://www.twitch.tv"

	payloadFmt := `
    {
      "status": 200,
      "message": "",
      "meta": {},
      "data": {
        "tip": {
          "body": "%s",
          "url": "%s"
        }
      }
    }
  `

	payload := fmt.Sprintf(
		payloadFmt,
		body,
		url,
	)

	server := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		suite.Equal("/v1/stream_summary/tip", r.URL.EscapedPath())

		w.WriteHeader(http.StatusOK)

		_, err := w.Write([]byte(payload))
		suite.NoError(err)
	}))

	defer server.Close()

	client, err := NewClient(twitchclient.ClientConf{
		Host: server.URL,
	})
	suite.NoError(err)

	language := "en"

	resp, err := client.GetV1Tip(context.Background(), language, nil)
	suite.NoError(err)

	if suite.NotNil(resp) {

		tip := resp.Data.Tip

		suite.Equal(body, tip.Body)
		suite.Equal(url, tip.URL)
	}
}
