package dashy

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/dashy/view/vpdemographics"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1VideoPlayDemographicsByTime makes a GET request to the Dashy Service for
// demographic breakdowns for all video plays
func (c *client) GetV1VideoPlayDemographicsByTime(ctx context.Context, params *vpdemographics.GetV1VideoPlayDemographicsByTimeReqParams, reqOpts *twitchclient.ReqOpts) (*vpdemographics.Response, error) {
	err := params.Validate()
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/stats/channels/%s/video_play_demographics", params.ChannelID)

	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()
	query.Add("start_time", params.StartTime.UTC().Format(time.RFC3339))
	query.Add("end_time", params.EndTime.UTC().Format(time.RFC3339))
	req.URL.RawQuery = query.Encode()

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-dashy.get_video_play_demographics_by_time",
		StatSampleRate: 0.1,
	})

	response := &vpdemographics.Response{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
