package main

import (
	"fmt"
	"os"

	"code.justin.tv/cb/dashy/internal/auth"
)

const (
	defaultKeyPath = "internal/auth/development_ecc_private.key"
)

func main() {
	if len(os.Args) < 2 {
		fmt.Println("Usage:", os.Args[0], "<channel_id> [<capability>]")
		return
	}

	var capability string
	if len(os.Args) == 2 {
		capability = os.Args[2]
	} else {
		capability = "view_stats"
	}

	channelID := os.Args[1]

	encoder, err := auth.NewEncoder(defaultKeyPath)
	if err != nil {
		fmt.Println(fmt.Errorf("Could not create Encoder: %v", err))
		return
	}

	token := encoder.GenerateToken(capability, channelID)
	if token != nil {
		str, err := token.String()
		if err != nil {
			fmt.Println(fmt.Errorf("Could not generate token: %v", err))
			return
		}

		fmt.Println(str)
	} else {
		fmt.Println("Could not generate token")
	}
}
